<?php

include_once ($_SERVER['DOCUMENT_ROOT']."/vars.inc.php");
include_once ($_SERVER['DOCUMENT_ROOT']."/netcat/modules/stats/openstat/function.inc.php");

define('TEDDYID_JAVASCRIPT', '<script src="https://www.teddyid.com/js/teddypass.js" defer></script>');
/**
 * Проставить teddy на все страницы
 * @param bool ставить ли в xml и пустые макеты, 0 (по умолчанию) - не ставить
 * @return int 1 в случае успеха
 */
function nc_openstat_put_teddyid_javascript_to_templates($check_xml = 0) {
	
	global $db, $nc_core;
	
    $templates = $db->get_results("SELECT `Template_ID`, `Parent_Template_ID`, `Header`, `Footer`, `File_Mode`, `File_Path` FROM `Template`WHERE `Template_ID`<>'".$nc_core->get_settings('EditDesignTemplateID')."'");
		
    if (!$templates) {
        return 0;
    }
	
    foreach ($templates as $templ) {
    	if ($templ->File_Mode) {
    		$templ->Header = file_get_contents($nc_core->TEMPLATE_FOLDER.$templ->File_Path.'/Header.html');
    		$templ->Footer = file_get_contents($nc_core->TEMPLATE_FOLDER.$templ->File_Path.'/Footer.html');
    	}
		
        if (!$check_xml) {  // считаем, что в пустых xml макетах все и так хорошо и javascript не нужен
            if (nc_strpos($templ->Header, "<?xml") !== FALSE) {
                continue;
            }

            if (($templ->Footer == '') && ($templ->Header == '') && ($templ->Parent_Template_ID == 0)) {
                continue;
            }
        }
	
        if (!(($templ->Footer == '') && ($templ->Parent_Template_ID != 0)) && nc_strpos($templ->Footer, '%Footer') === FALSE) { // если есть родитель и футер пустой, то он же наследуется
            if (nc_strpos($templ->Footer, TEDDYID_JAVASCRIPT) === FALSE) {
                if (nc_preg_match_all("#[ \t]*<[ \t]*\/[ \t]*body[ \t]*>#i", $templ->Footer, $matches, PREG_OFFSET_CAPTURE)) {  //ищем </body>
                    $body_pos = $matches[0][count($matches[0]) - 1][1];  // позиция последнего тега </body>
                    $new_footer = substr_replace($templ->Footer, TEDDYID_JAVASCRIPT."\n", $body_pos, 0);  // вставка подстроки
                } elseif (nc_preg_match_all("#[ \t]*<[ \t]*\/[ \t]*html[ \t]*>#i", $templ->Footer, $matches, PREG_OFFSET_CAPTURE)) {  //ищем </html>
                    $body_pos = $matches[0][count($matches[0]) - 1][1];  // позиция последнего тега </html>
                    $new_footer = substr_replace($templ->Footer, TEDDYID_JAVASCRIPT."\n", $body_pos, 0);  // вставка подстроки
                } else {  // если не получилось - вставляем просто в конец футера
                    $new_footer = $templ->Footer."\n".TEDDYID_JAVASCRIPT;
                }

                if ($templ->File_Mode) {
                	$res = file_put_contents($nc_core->TEMPLATE_FOLDER.$templ->File_Path.'/Footer.html', $new_footer);
                	if (false === $res) {
                		return 0;
                	}
                } else {
                    $db->query("UPDATE `Template` SET `Footer`=\"".$db->prepare($new_footer)."\" WHERE `Template_ID`='".$templ->Template_ID."'");
                }
            }
        } else {
            if (nc_openstat_check_teddyid_in_templates_sub_check($templ->Template_ID, $tmp, $check_xml)) { // если в родительских нет счетчика
                $new_footer = TEDDYID_JAVASCRIPT."\n%Footer";
                
                if ($templ->File_Mode) {
                	$res = file_put_contents($nc_core->TEMPLATE_FOLDER.$templ->File_Path.'/Footer.html', $new_footer);
                	if (false === $res) {
                		return 0;
                	}
                } else {
                	$db->query("UPDATE `Template` SET `Footer`=\"".$db->prepare($new_footer)."\" WHERE `Template_ID`='".$templ->Template_ID."'");
                }                
            }
        }
    }
    return 1;
}

/**
 * Убрать teddy со всех страниц
 * @return int 1 в случае успеха
 */
function nc_openstat_delete_teddyid_javascript_from_templates() {

    global $db, $nc_core;
	
    $templates = $db->get_results("SELECT `Template_ID`, `Parent_Template_ID`, `Header`, `Footer`, `File_Mode`, `File_Path` FROM `Template` WHERE `Template_ID`<>'".$nc_core->get_settings('EditDesignTemplateID')."'");
    if (!$templates) {
        return 1;
    }

    foreach ($templates as $templ) {
        if ($templ->File_Mode) {
            $templ->Header = file_get_contents($nc_core->TEMPLATE_FOLDER.$templ->File_Path.'/Header.html');
            $templ->Footer = file_get_contents($nc_core->TEMPLATE_FOLDER.$templ->File_Path.'/Footer.html');
    	}
        
        if (nc_strpos($templ->Footer, TEDDYID_JAVASCRIPT) !== FALSE) {
            $new_footer = str_replace('\n'.TEDDYID_JAVASCRIPT, "", $templ->Footer);
            $new_footer = str_replace(TEDDYID_JAVASCRIPT.'\n', "", $templ->Footer);
            $new_footer = str_replace(TEDDYID_JAVASCRIPT, "", $templ->Footer);
                
            if($templ->File_Mode){
                $res = file_put_contents($nc_core->TEMPLATE_FOLDER.$templ->File_Path.'/Footer.html', $new_footer);
                if (false === $res) {
                    return 0;
                }
            }else{
                $db->query("UPDATE `Template` SET `Footer`=\"".$db->prepare($new_footer)."\" WHERE `Template_ID`='".$templ->Template_ID."'");
            }
        }
    }
    return 1;
}

/**
 * Рекурсивная проверка наличия teddyid в шаблоне.
 * @return int NULL, если нет шаблона. Число если есть шаблон
 */
function nc_openstat_check_teddyid_in_templates_sub_check($el, &$templ = NULL, $check_xml=0) {
    global $nc_core, $db;

    if ($el == 0) {
        return 0;
    }
    if (!$templ) {
        $templates = $db->get_results("SELECT `Template_ID`, `Parent_Template_ID`, `Header`, `Footer` FROM `Template`");
        foreach ($templates as $t) {
            $templ[$t->Template_ID] = $t;
        }
    }

    if (!$check_xml) {  // считаем, что в пустых xml макетах все и так хорошо и teddyid не нужен
        if (nc_strpos($templ[$el]->Header, "<?xml") !== FALSE) {
            return 0;
        }

        if (($templ[$el]->Footer == '') && ($templ[$el]->Header == '') && ($templ[$el]->Parent_Template_ID == 0)) {
			return 0;
        }
    }


    if (!(($templ[$el]->Footer == '') && ($templ[$el]->Parent_Template_ID != 0))) { // если есть родитель и футер пустой, то он же наследуется
        return (nc_strpos($templ[$el]->Footer, TEDDYID_JAVASCRIPT) === FALSE);
    } elseif (!(($templ[$el]->Header == '') && ($templ[$el]->Parent_Template_ID != 0))) { // если есть родитель и футер пустой, то он же наследуется
        return (nc_strpos($templ[$el]->Header, TEDDYID_JAVASCRIPT) === FALSE);
    } else {
        return nc_openstat_check_counter_in_templates_sub_check($templ[$el]->Parent_Template_ID, $templ);
    }
}