<?php

/**
 * @author nex2hex nex2hex@ya.ru
 * @version 1.02
 */

class ncLog {
	protected $ncLogFile, $ncLogDb;
	const VERSION = "0.1.3";

	public function __construct() {
		$this->ncLogFile 	= ncLogFile::getInstance();
		$this->ncLogDb 		= ncLogDb::getInstance();
	}

	// extend ncLogDb
	public function __call($method, $args = array()) {
		return call_user_func_array ( array ($this->ncLogDb, $method ), $args );
	}

	/*
	 * Error log
	 */
	public function errorGetLogs() {
		return $this->ncLogFile->getLogs();
	}

	public function errorGet($errorFile) {
		return $this->ncLogFile->get($errorFile);
	}

	public function errorAdd($eventGroup, $event, $error, $options) {
		return $this->ncLogFile->add($eventGroup, $event, $error, $options);
	}

	public function errorDelete($errorFile) {
		return $this->ncLogFile->delete($errorFile);
	}

	public function errorAddCallback($errorFile) {
		return $this->ncLogFile->setCallback($event, $callback);
	}
}