<?php

/**
 * @author nex2hex nex2hex@ya.ru
 * @version 1.00
 */

abstract class ncLogAbsctract {
	protected $callback;

	public static $timestamp = 'Y-m-d H:i:s';
	public static $timezone;

	const EVENT_ALL = '*';
	const EVENT_DEFAULT = '';

	public function __construct() {
	}

	/*
    public static function getInstance() {
        if (static::$instance === null) {
            static::$instance = new static;
            static::$instance->init();
        }
        return static::$instance;
    }*/

    protected function init() {
    }

	protected function filterEvent($event, $allow_all = false) {
		$event = substr ( trim ( $event ), 0, 255 );
		if (! $event || (!$allow_all && $event == self::EVENT_ALL)) {
			$event = self::EVENT_DEFAULT;
		}
		return $event;
	}

	/**
	 * Log event
	 *
	 * @param string $event event type
	 * @param sring	$message message
	 * @param array $options options
	 * @return boolean true, if continue execution
	 */
	public function add(&$eventGroup, &$event, &$message, &$options = array()) {
		global $AUTH_USER_ID;
		$options += array(
			'priority'	=> 2,
			'userId'	=> intval ( $AUTH_USER_ID ),
			'options'	=> array()
		);
		$options['priority'] = intval($options['priority']);
		$options['userId'] 	 = intval($options['userId']);
		$options['options']  = is_array($options['options']) ? $options['options'] : array();
		$event				 = $this->filterEvent($event);
		$eventGroup			 = $this->filterEvent($eventGroup);

		if (self::$timezone) {
			$time = new DateTime( 'now', new DateTimeZone ( self::$timezone ) );
			$time = $time->format ( self::$timestamp );
		} else {
			$time = date ( self::$timestamp );
		}
		$options ['date'] = $time;

		if ((isset ( $this->callback [$eventGroup] ) && isset ( $this->callback [$eventGroup] [$event] ) || isset ( $this->callback [$eventGroup] [self::EVENT_ALL] )) || isset ( $this->callback [self::EVENT_ALL] )) {
			if (isset ( $this->callback [$eventGroup] )) {
				$opt = isset ( $this->callback [$eventGroup] [$event] ) ? $this->callback [$eventGroup] [$event] : $this->callback [$eventGroup] [self::EVENT_ALL];
			} else {
				$opt = $this->callback [self::EVENT_ALL];
			}
			return call_user_func ( $opt ['callback'], $eventGroup, $event, $message, $options, $opt ['options'] );
		}

		return true;
	}

	/**
	 * Clean
	 *
	 * @param string $event event type
	 * @param array $options options
	 */
	public function delete() {
	}

	/**
	 * Read
	 *
	 * @param string $event event type
	 * @param array $options options
	 */
	public function get() {
	}

	/**
	 * Set callback to event
	 *
	 * @param string $event event type
	 * @param function $callback user function
	 * @param array $options options passed to function
	 */
	public function setCallback($eventGroup, $event, $callback, $options = array()) {
		$event 		= $this->filterEvent($event, true);
		$eventGroup = $this->filterEvent($eventGroup, true);
		if(!isset($this->callback[$eventGroup])) {
			$this->callback[$eventGroup] = array();
		}
		$this->callback[$eventGroup][$event] = array(
			'callback'	=> $callback,
			'options'	=> $options
		);
	}
}