<?php
class Pusher
{
    function __construct()
    {
        global $db;
        $this->db = $db;
    }

    /**
     *
     * Отправка пуш сообщений на android-устройства
     *
     * @param $title - заголовок сообщения
     * @param $message - текст сообщения
     * @param $device_id - передаем, если нужно послать только на одно устройство
     */
    public function sendPushes($title, $message, $device_id = 0)
    {
        if(!empty($device_id)){
            $devices = array($device_id);
        }else{
            $devices = $this->getDevices();
        }
        // если пустой заголовок или текст сообщения - не будем отправлять
        if(empty($message) || empty($title))
        {
            return false;
        }
        if(!empty($devices))
        {
            // Google накладывает ограничение - 1000 устройств за раз!
            $tokens_to_send = array_chunk($devices, 1000);
            // для каждой тысячи

            foreach($tokens_to_send as $tokens_arr)
            {
                $google_api_key = 'YOUR GOOGLE API KEY';

                $url = 'https://android.googleapis.com/gcm/send';



                $fields = array(
                    'registration_ids' => $tokens_arr,
                    'data' => array('title' => $title, 'message' => $message),
                );

                $headers = array(
                    'Authorization: key=' . $google_api_key,
                    'Content-Type: application/json'
                );

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);


                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));


                $result = curl_exec($ch);
                if ($result === FALSE) {
                    die('Curl failed: ' . curl_error($ch));
                }

                curl_close($ch);
                // обновляем девайсы, на которые отправили пуши
                $this->updateAndroidDevices($tokens_arr);
            }
        }
    }

    /**
     * Получим все устройства на Android, которые есть в базе
     * @return array устройства
     */
    public function getDevices()
    {
        $sql = "SELECT unique_id FROM android_devices";
        $devices = $this->db->get_results($sql, ARRAY_A);
        $devices_array = array();
        foreach($devices as $device)
        {
            $devices_array[] = $device['unique_id'];
        }
        return $devices_array;
    }

    /**
     * Обновим время отправки  пуша для Android-устройств
     * @param array $tokens_arr - массив id устройств
     */
    public function updateAndroidDevices($tokens_arr)
    {
        if(!empty($tokens_arr))
        {
            $tokens_str = implode(',',$tokens_arr);
            $sql = "UPDATE android_devices SET last_push = ".time()." WHERE unique_id IN (".$tokens_str.")";
            $this->db->query($sql);
        }
    }
}

?>