<?php

$NETCAT_FOLDER = realpath(dirname(__FILE__) . "/../../../") . "/";
require_once($NETCAT_FOLDER . "vars.inc.php");
require_once($ADMIN_FOLDER . "function.inc.php");

if (is_file($MODULE_FOLDER . "CDNVideo/" . MAIN_LANG . ".lang.php")) {
    require_once($MODULE_FOLDER . "CDNVideo/" . MAIN_LANG . ".lang.php");
} else {
    require_once($MODULE_FOLDER . "CDNVideo/en.lang.php");
}

require_once($MODULE_FOLDER . "CDNVideo/ncCDNVideo.class.php");
$moduleParams = ncCDNVideo::getCDNVideoCofig();

// UI config
require_once($ADMIN_FOLDER . "modules/ui.php");
// default
if (!$page) $page = "settings";
require_once($MODULE_FOLDER . "CDNVideo/ui_config.php");

$UI_CONFIG = new ui_config_module_CDNVideo('admin', $page);

$perm->ExitIfNotAccess(NC_PERM_MODULE, 0, 0, 0, 1);

global $UI_CONFIG;

$UI_CONFIG->actionButtons[] = array(
    "id" => "submit",
    "caption" => NETCAT_MODULE_PAYMENT_ADMIN_BUTTON_SAVE,
    "action" => "mainView.submitIframeForm('setSettings')"
);
unset($UI_CONFIG->tabs[1]);

$Title1 = NETCAT_MODULES;
$Title2 = CDNVIDEO_MODULE_NAME;

function is_valid_domain_name($domain_name) {
    return (preg_match("/^([a-z\d](-*[a-z\d])*)(\.([a-z\d](-*[a-z\d])*))*$/i", $domain_name) //valid chars check
        && preg_match("/^.{1,253}$/", $domain_name) //overall length check
        && preg_match("/^[^\.]{1,63}(\.[^\.]{1,63})*$/", $domain_name)   ); //length of each label
}

//обработаем post
if($nc_core->input->fetch_post('CDN_Video_URL') !== false){
    $domains = array(
        'CDN_Video_URL' => $nc_core->input->fetch_post('CDN_Video_URL'),
        'CDN_Video_URL_AV' => $nc_core->input->fetch_post('CDN_Video_URL_AV'),
    );
    $invalidDomains = array(
        'CDN_Video_URL' => array(),
        'CDN_Video_URL_AV' => array(),
    );
    
    foreach(array('CDN_Video_URL','CDN_Video_URL_AV') as $paramName){
        $tempArr = explode(',', $domains[$paramName]);
        foreach($tempArr as $key => &$item){
            $item = str_ireplace('http://', '', trim($item));
            
            if(empty($item)){
                unset($tempArr[$key]);
                continue;
            }
            if(!is_valid_domain_name($item)){
                $invalidDomains[$paramName][] = $item;
                unset($tempArr[$key]);
            }
        }
        $domains[$paramName] = implode(',', $tempArr);
    }

    $post = $nc_core->input->fetch_post();
    $mapping = array(
        'CDN_Video_Active' => ($nc_core->input->fetch_post('CDN_Video_Active') === 'true' && !empty($domains['CDN_Video_URL'])) ? 'true' : 'false',
        'CDN_Video_ID' => !empty($post['CDN_Video_ID'])? $post['CDN_Video_ID'] : 0,
        'CDN_Video_URL' => $domains['CDN_Video_URL'],
        'CDN_Video_Cache' => ($nc_core->input->fetch_post('CDN_Video_Clear_Cache') === 'true')? time() : $moduleParams['init_time'],
        'CDN_Video_TTL' => !empty($post['CDN_Video_TTL'])? $post['CDN_Video_TTL'] : 14*24*3600,
        'CDN_Video_Active_AV' => ($nc_core->input->fetch_post('CDN_Video_Active_AV') === 'true' && !empty($domains['CDN_Video_URL_AV'])) ? 'true' : 'false',
        'CDN_Video_URL_AV' => $domains['CDN_Video_URL_AV'],
        'CDN_Video_Cache_AV' => ($nc_core->input->fetch_post('CDN_Video_Clear_Cache_AV') === 'true')? time() : $moduleParams['init_time_av'],
        'CDN_Video_TTL_AV' => !empty($post['CDN_Video_TTL_AV'])? $post['CDN_Video_TTL_AV'] : 14*24*3600,
    );
    ncCDNVideo::saveParameters($mapping);
    $moduleParams = array(
            'active' => $mapping['CDN_Video_Active'] === 'true',
            'id' => $mapping['CDN_Video_ID'],
            'domain' => $mapping['CDN_Video_URL'],
            'init_time' => $mapping['CDN_Video_Cache'],
            'ttl' => $mapping['CDN_Video_TTL'],
            'active_av' => $mapping['CDN_Video_Active_AV'] === 'true',
            'domain_av' => $mapping['CDN_Video_URL_AV'],
            'init_time_av' => $mapping['CDN_Video_Cache_AV'],
            'ttl_av' => $mapping['CDN_Video_TTL_AV'],
    );
    $saved = true;
}

BeginHtml($Title2, $Title1, "http://" . $DOC_DOMAIN . "/settings/modules/CDNVideo/");
?>
<form method='post' id='setSettings' action=''>
    <table width='100%' class='admin_table'>
        <tbody>
            <tr>
                <td width='200px'><?= CDNVIDEO_MODULE_FORM_ACTIVE ?></td>
                <td><input type="checkbox" name='CDN_Video_Active' id='CDN_Video_Active' value='true' <?= ($moduleParams['active'] === true)?'checked':''?> onclick="showMessage('module');">
                    <div id='CDNVIDEO_MODULE_FORM_ACTIVATED' style="display: none">
                    <?= CDNVIDEO_MODULE_FORM_ACTIVATED ?>
                    </div>
                </td>
            </tr>
            <tr style="display: none">
                <td><?= CDNVIDEO_MODULE_FORM_ID ?></td><td><input type="text" name='CDN_Video_ID' value='<?= $moduleParams['id'] ?>'></td>
            </tr>
            <tr>
                <td colspan="2" style="text-align: center"><h4><?= CDNVIDEO_MODULE_FORM_FILES_SECTION ?></h4></td>
            </tr>
            <tr>
                <td><?= CDNVIDEO_MODULE_FORM_DOMAIN ?></td>
                <td>
                    <input type="text" name='CDN_Video_URL' value='<?= $moduleParams['domain'] ?>' size="100%"><br>
                    <em>(Через запятую можно ввести несколько доменов.)</em>
                </td>
            </tr>
            <tr>
                <td><?= CDNVIDEO_MODULE_FORM_TTL ?></td><td><input type="text" name='CDN_Video_TTL' value='<?= $moduleParams['ttl'] ?>'></td>
            </tr>
            <tr>
                <td><?= CDNVIDEO_MODULE_FORM_CLEAR_CACHE ?></td><td><input type="checkbox" name='CDN_Video_Clear_Cache' value='true'></td>
            </tr>
            <tr>
                <td colspan="2" style="text-align: center"><h4><?= CDNVIDEO_MODULE_FORM_AV_SECTION ?></h4></td>
            </tr>
            <tr>
                <td width='150px'><?= CDNVIDEO_MODULE_FORM_ACTIVE_AV ?></td>
                <td><input type="checkbox" name='CDN_Video_Active_AV' id='CDN_Video_Active_AV' value='true' <?= ($moduleParams['active_av'] === true)?'checked':''?> onclick="showMessage('section');">
                    <div id='CDNVIDEO_MODULE_FORM_ACTIVATED_AV' style="display: none">
                    <?= CDNVIDEO_MODULE_FORM_ACTIVATED_AV ?>
                    </div>
                </td>
            </tr>
            <tr>
                <td><?= CDNVIDEO_MODULE_FORM_DOMAIN ?></td>
                <td>
                    <input type="text" name='CDN_Video_URL_AV' value='<?= $moduleParams['domain_av'] ?>' size="100%"><br>
                    <em>(Через запятую можно ввести несколько доменов.)</em>
                </td>
            </tr>
            <tr>
                <td><?= CDNVIDEO_MODULE_FORM_TTL ?></td><td><input type="text" name='CDN_Video_TTL_AV' value='<?= $moduleParams['ttl_av'] ?>'></td>
            </tr>
            <tr>
                <td><?= CDNVIDEO_MODULE_FORM_CLEAR_CACHE ?></td><td><input type="checkbox" name='CDN_Video_Clear_Cache_AV' value='true'></td>
            </tr>
        </tbody>
        <?php if(!empty($saved) && $saved):?>
        <tfoot class="CDN-table-footer">
            <tr>
                <td colspan="2">
                    <h4>
                        <?= (!empty($saved) && $saved)? CDNVIDEO_MODULE_FORM_SAVED : '' ?>
                        <?= ($nc_core->input->fetch_post('CDN_Video_Clear_Cache') === 'true')? '<br>' . CDNVIDEO_MODULE_FORM_CACHE_CLEARED : '' ?>
                        <?= ($nc_core->input->fetch_post('CDN_Video_Clear_Cache_AV') === 'true')? '<br>' . CDNVIDEO_MODULE_FORM_CACHE_AV_CLEARED : '' ?>
                        <?= (!empty($invalidDomains['CDN_Video_URL']))? '<br>' . CDNVIDEO_MODULE_FORM_INV_DOMAINS . implode(',', $invalidDomains['CDN_Video_URL']) : '' ?>
                        <?= (!empty($invalidDomains['CDN_Video_URL_AV']))? '<br>' . CDNVIDEO_MODULE_FORM_INV_DOMAINS_AV . implode(',', $invalidDomains['CDN_Video_URL_AV']) : '' ?>
                    </h4>
                </td>
            </tr>
        </tfoot>
        <?php endif; ?>
    </table>
</form>
<script type="text/javascript">
    $(function() {
        setTimeout(function(){ $('.CDN-table-footer').fadeOut(1000); }, 30000);
    });
    var initialModuleState = $('#CDN_Video_Active').prop("checked");
    var initialModuleStateAV = $('#CDN_Video_Active_AV').prop("checked");
    
    function showMessage(type){
        if(type == 'module'){
            var currentModuleState = $('#CDN_Video_Active').prop("checked");
            if(!initialModuleState && currentModuleState){
                $('#CDNVIDEO_MODULE_FORM_ACTIVATED').show();
            }
        }else{
            var currentModuleStateAV = $('#CDN_Video_Active_AV').prop("checked");
            if(!initialModuleStateAV && currentModuleStateAV){
                $('#CDNVIDEO_MODULE_FORM_ACTIVATED_AV').show();
            }
        }
    }

</script>
<?php

EndHtml();


?>